participants_control <- read.csv("anonymized_icer2023.csv", sep=";")

participants_girls = subset(participants_control, participants_control$gender=="Meisje")
participants_boys = subset(participants_control, participants_control$gender=="Jongen")

participants_experience <- function(participants, experience){
  if (experience == "No") {
    subset_experience = subset(participants, participants$experience == "{Nee}"
                               | grepl("Ik weet niet wat programmeren is",participants$experience)
    )
  } 
  if (experience == "Yes" | experience == "Yes-school" | experience == "Yes-home" | experience == "Yes-outofschool") {
    subset_experience = subset(participants, participants$experience != "{Nee}"
                               & participants$experience != "{Ik weet niet wat programmeren is}"
                               & participants$experience != "{Nee,Ik weet niet wat programmeren is}"
                               & participants$experience != "{Ja, op school,Ik weet niet wat programmeren is}"
                               & participants$experience != "{Ja, op school,Nee,Ik weet niet wat programmeren is}"
                               & participants$experience != "{Ja, op een activiteit buiten school bijvoorbeeld in de bibliotheek of bij een codeclub,Ja, bij familie, vrienden of thuis,Ik weet niet wat programmeren is}"
                               & participants$experience != "{Ja, op school,Ja, op een activiteit buiten school bijvoorbeeld in de bibliotheek of bij een codeclub,Ja, bij familie, vrienden of thuis,Ik weet niet wat programmeren is}"
    )
  }
  if (experience == "Yes-school") {
    subset_experience = subset(subset_experience, grepl("Ja, op school",subset_experience$experience))
  } 
  if (experience == "Yes-home") {
    subset_experience = subset(subset_experience, grepl("Ja, bij familie, vrienden of thuis",subset_experience$experience))
  } 
  if (experience == "Yes-outofschool") {
    subset_experience = subset(subset_experience, grepl("Ja, op een activiteit buiten school bijvoorbeeld in de bibliotheek of bij een codeclub",subset_experience$experience))
  } 
  
  return(subset_experience)
}

data = participants_control
participants_control_exp_yes = participants_experience(data, "Yes")
participants_control_exp_yes_school = participants_experience(data, "Yes-school")
participants_control_exp_yes_home = participants_experience(data, "Yes-home")
participants_control_exp_yes_outofschool = participants_experience(data, "Yes-outofschool")
participants_control_exp_no = participants_experience(data, "No")
#rm(data, participants_school_exp_yes, participants_school_exp_yes_school, participants_school_exp_yes_home, participants_school_exp_yes_outofschool, participants_school_exp_no)

data = participants_boys
participants_boys_exp_yes = participants_experience(data, "Yes")
participants_boys_exp_yes_school = participants_experience(data, "Yes-school")
participants_boys_exp_yes_home = participants_experience(data, "Yes-home")
participants_boys_exp_yes_outofschool = participants_experience(data, "Yes-outofschool")
participants_boys_exp_no = participants_experience(data, "No")
#rm(data, participants_school_exp_yes, participants_school_exp_yes_school, participants_school_exp_yes_home, participants_school_exp_yes_outofschool, participants_school_exp_no)

data = participants_girls
participants_girls_exp_yes = participants_experience(data, "Yes")
participants_girls_exp_yes_school = participants_experience(data, "Yes-school")
participants_girls_exp_yes_home = participants_experience(data, "Yes-home")
participants_girls_exp_yes_outofschool = participants_experience(data, "Yes-outofschool")
participants_girls_exp_no = participants_experience(data, "No")
#rm(data, participants_school_exp_yes, participants_school_exp_yes_school, participants_school_exp_yes_home, participants_school_exp_yes_outofschool, participants_school_exp_no)

participants_age_7_8 = subset(participants_control, participants_control$age_category == 1)
participants_age_9_10 = subset(participants_control, participants_control$age_category == 2)
participants_age_11_12 = subset(participants_control, participants_control$age_category == 3)
participants_age_13_14 = subset(participants_control, participants_control$age_category == 4)

rm(data)
rm(participants_experience)
